
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # hours worked by Peggy
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # hours worked by Bobby
    x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # hours worked by John


    # Set objective function
    model.setObjective(7.79*x0**2 + 1.47*x0*x2 + 6.87*x1**2 + 8.03*x1*x2 + 4.71*x2**2 + 9.57*x0 + 3.55*x1 + 4.7*x2, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12*x0 + 29*x1 >= 44, "c0")
    model.addConstr(12*x0 + 26*x2 >= 72, "c1")
    model.addConstr(29*x1 + 26*x2 >= 55, "c2")
    model.addConstr(12*x0 + 29*x1 + 26*x2 >= 55, "c3")
    model.addConstr(9*x0 + 7*x1 >= 61, "c4")
    model.addConstr(9*x0**2 + 28*x2**2 >= 61, "c5")
    model.addConstr(9*x0 + 7*x1 + 28*x2 >= 53, "c6")
    model.addConstr(8*x0 - 3*x2 >= 0, "c7")
    model.addConstr(12*x0**2 + 26*x2**2 <= 129, "c8")
    model.addConstr(12*x0**2 + 29*x1**2 <= 214, "c9")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % model.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
