
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Peggy
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bobby
    x2 = model.addVar(name="x2", lb=0)  # hours worked by John

    # Objective function
    model.setObjective(7.79 * x0**2 + 1.47 * x0 * x2 + 6.87 * x1**2 + 8.03 * x1 * x2 + 4.71 * x2**2 + 9.57 * x0 + 3.55 * x1 + 4.7 * x2)

    # Constraints
    model.addConstr(12 * x0 + 29 * x1 >= 44)
    model.addConstr(12 * x0 + 26 * x2 >= 72)
    model.addConstr(29 * x1 + 26 * x2 >= 55)
    model.addConstr(12 * x0 + 29 * x1 + 26 * x2 >= 55)
    model.addConstr(9 * x0 + 7 * x1 >= 61)
    model.addConstr(9 * x0**2 + 28 * x2**2 >= 61)
    model.addConstr(9 * x0 + 7 * x1 + 28 * x2 >= 53)
    model.addConstr(8 * x0 - 3 * x2 >= 0)
    model.addConstr(144 * x0**2 + 676 * x2**2 <= 129)
    model.addConstr(144 * x0**2 + 841 * x1**2 <= 214)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("The model is infeasible")

optimization_problem()
