
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    ham_sandwiches = m.addVar(vtype=gp.GRB.INTEGER, name="ham_sandwiches")
    corn_cobs = m.addVar(vtype=gp.GRB.INTEGER, name="corn_cobs")

    # Set objective function
    m.setObjective(5 * ham_sandwiches + 6 * corn_cobs, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(10.81 * ham_sandwiches + 1.92 * corn_cobs >= 28, "calcium_min")
    m.addConstr(11.85 * ham_sandwiches + 6.3 * corn_cobs >= 22, "umami_min")
    m.addConstr(2.72 * ham_sandwiches + 8.06 * corn_cobs >= 22, "iron_min")
    m.addConstr(9 * ham_sandwiches - 2 * corn_cobs >= 0, "sandwich_corn_ratio")
    m.addConstr(10.81 * ham_sandwiches + 1.92 * corn_cobs <= 38, "calcium_max")
    m.addConstr(11.85 * ham_sandwiches + 6.3 * corn_cobs <= 61, "umami_max")
    m.addConstr(2.72 * ham_sandwiches + 8.06 * corn_cobs <= 44, "iron_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('ham_sandwiches:', ham_sandwiches.x)
        print('corn_cobs:', corn_cobs.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
