
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="ham_sandwiches")
x1 = m.addVar(vtype=GRB.INTEGER, name="corn_cobs")

# Set the objective function
m.setObjective(5*x0 + 6*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10.81*x0 + 1.92*x1 >= 28, "calcium_lower")
m.addConstr(10.81*x0 + 1.92*x1 <= 38, "calcium_upper")
m.addConstr(11.85*x0 + 6.3*x1 >= 22, "umami_lower")
m.addConstr(11.85*x0 + 6.3*x1 <= 61, "umami_upper")
m.addConstr(2.72*x0 + 8.06*x1 >= 22, "iron_lower")
m.addConstr(2.72*x0 + 8.06*x1 <= 44, "iron_upper")
m.addConstr(9*x0 - 2*x1 >= 0, "mixed_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Ham Sandwiches: {x0.x}")
    print(f"Corn Cobs: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
