
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="ham_sandwiches", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="corn_cobs", vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(5 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10.81 * x1 + 1.92 * x2 >= 28, name="calcium_constraint")
model.addConstr(11.85 * x1 + 6.3 * x2 >= 22, name="umami_index_constraint")
model.addConstr(2.72 * x1 + 8.06 * x2 >= 22, name="iron_constraint")
model.addConstr(9 * x1 - 2 * x2 >= 0, name="ham_sandwiches_corn_cobs_relationship")
model.addConstr(10.81 * x1 + 1.92 * x2 <= 38, name="calcium_upper_bound")
model.addConstr(11.85 * x1 + 6.3 * x2 <= 61, name="umami_index_upper_bound")
model.addConstr(2.72 * x1 + 8.06 * x2 <= 44, name="iron_upper_bound")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of ham sandwiches: {x1.varValue}")
    print(f"Number of corn cobs: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
