
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
john = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="john")
laura = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="laura")


# Set objective function
m.setObjective(5.29*jean**2 + 4.38*jean*mary + 6.98*jean*laura + 2.49*mary**2 + 2.57*mary*peggy + 7.28*mary*john + 2.3*mary*laura + 5.14*peggy*john, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*jean + 1*john >= 19)
m.addConstr(2*jean + 8*peggy >= 13)
m.addConstr(8*peggy + 5*laura >= 12)
m.addConstr(1*john + 5*laura >= 19)
m.addConstr(5*mary + 1*john >= 11)
m.addConstr(5*mary**2 + 8*peggy**2 + 5*laura**2 >= 24)
m.addConstr(5*mary + 8*peggy + 1*john >= 24)
m.addConstr(2*jean**2 + 1*john**2 + 5*laura**2 >= 24)
m.addConstr(2*jean + 5*mary + 1*john >= 24)
m.addConstr(5*mary + 8*peggy + 5*laura >= 12)
m.addConstr(5*mary + 8*peggy + 1*john >= 12)
m.addConstr(2*jean + 1*john + 5*laura >= 12)
m.addConstr(2*jean**2 + 5*mary**2 + 1*john**2 >= 12)
m.addConstr(5*mary + 8*peggy + 5*laura >= 15)
m.addConstr(5*mary**2 + 8*peggy**2 + 1*john**2 >= 15)
m.addConstr(2*jean + 1*john + 5*laura >= 15)
m.addConstr(2*jean**2 + 5*mary**2 + 1*john**2 >= 15)
m.addConstr(5*mary**2 + 8*peggy**2 + 5*laura**2 >= 23)
m.addConstr(5*mary**2 + 8*peggy**2 + 1*john**2 >= 23)
m.addConstr(2*jean + 1*john + 5*laura >= 23)
m.addConstr(2*jean**2 + 5*mary**2 + 1*john**2 >= 23)
m.addConstr(2*jean + 5*mary + 8*peggy + 1*john + 5*laura >= 23)
m.addConstr(1*john**2 + 1*laura**2 >= 17)
m.addConstr(1*peggy**2 + 1*john**2 >= 11)
m.addConstr(8*jean**2 + 1*peggy**2 >= 9)
m.addConstr(8*jean + 4*mary + 1*peggy + 1*john + 1*laura >= 9)
m.addConstr(7*jean**2 + 6*peggy**2 >= 21)
m.addConstr(6*peggy**2 + 5*laura**2 >= 20)
m.addConstr(7*jean + 6*mary + 6*peggy + 5*john + 5*laura >= 20)
m.addConstr(-3*peggy**2 + 4*john**2 >= 0)
m.addConstr(2*jean**2 + 8*peggy**2 <= 57)
m.addConstr(5*mary**2 + 5*laura**2 <= 112)
m.addConstr(8*peggy + 1*john <= 93)
m.addConstr(5*mary**2 + 1*john**2 <= 57)
m.addConstr(8*peggy + 1*john + 5*laura <= 96)
m.addConstr(4*mary**2 + 1*laura**2 <= 91)
m.addConstr(8*jean**2 + 4*mary**2 <= 50)
m.addConstr(4*mary**2 + 1*john**2 <= 30)
m.addConstr(8*jean + 1*peggy <= 124)
m.addConstr(1*peggy**2 + 1*john**2 <= 64)
m.addConstr(8*jean + 1*laura <= 106)
m.addConstr(1*peggy + 1*laura <= 73)
m.addConstr(1*john + 1*laura <= 96)
m.addConstr(8*jean + 4*mary + 1*laura <= 129)
m.addConstr(8*jean**2 + 1*john**2 + 1*laura**2 <= 65)
m.addConstr(8*jean + 1*peggy + 1*laura <= 106)
m.addConstr(4*mary**2 + 1*john**2 + 1*laura**2 <= 124)
m.addConstr(4*mary**2 + 1*peggy**2 + 1*laura**2 <= 90)
m.addConstr(8*jean**2 + 4*mary**2 + 1*peggy**2 <= 30)
m.addConstr(7*jean**2 + 6*mary**2 <= 79)
m.addConstr(6*peggy**2 + 5*john**2 <= 65)
m.addConstr(6*mary**2 + 5*laura**2 <= 26)
m.addConstr(7*jean**2 + 5*laura**2 <= 62)
m.addConstr(5*john + 5*laura <= 31)
m.addConstr(6*peggy + 5*laura <= 24)
m.addConstr(7*jean + 6*peggy <= 49)
m.addConstr(6*mary + 6*peggy + 5*john <= 74)
m.addConstr(6*mary + 6*peggy + 5*laura <= 44)
m.addConstr(7*jean + 6*peggy + 5*john <= 104)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

