
import gurobipy as gp

# Create a new model
model = gp.Model("optimize_work_hours")

# Create variables
hank_hours = model.addVar(vtype=gp.GRB.INTEGER, name="hank_hours")
george_hours = model.addVar(vtype=gp.GRB.INTEGER, name="george_hours")

# Set objective function
model.setObjective(1 * hank_hours + 9 * george_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * hank_hours + 2 * george_hours >= 22, "total_likelihood_min")
model.addConstr(7 * hank_hours + 2 * george_hours >= 30, "total_cost_min")
model.addConstr(3 * hank_hours - 4 * george_hours >= 0, "hours_relation")
model.addConstr(4 * hank_hours + 2 * george_hours <= 55, "total_likelihood_max")
model.addConstr(7 * hank_hours + 2 * george_hours <= 51, "total_cost_max")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print("Optimal Solution:")
    print(f"Hours worked by Hank: {hank_hours.x}")
    print(f"Hours worked by George: {george_hours.x}")
    print(f"Objective Value: {model.objVal}")

