
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")

# Set the objective function
m.setObjective(1*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 2*x2 >= 22, "Likelihood_to_Quit_Index_Constraint")
m.addConstr(7*x1 + 2*x2 >= 30, "Dollar_Cost_Per_Hour_Constraint_Lower_Bound")
m.addConstr(3*x1 - 4*x2 >= 0, "Hours_Worked_Relationship_Constraint")
m.addConstr(4*x1 + 2*x2 <= 55, "Likelihood_to_Quit_Index_Upper_Bound")
m.addConstr(7*x1 + 2*x2 <= 51, "Dollar_Cost_Per_Hour_Constraint_Upper_Bound")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
