
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Hank", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_George", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(x1 + 9 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(4 * x1 + 2 * x2 >= 22, name="likelihood_to_quit_index")
m.addConstr(7 * x1 + 2 * x2 >= 30, name="dollar_cost_per_hour")
m.addConstr(3 * x1 - 4 * x2 >= 0, name="hours_worked_constraint")
m.addConstr(4 * x1 + 2 * x2 <= 55, name="likelihood_to_quit_index_upper_bound")
m.addConstr(7 * x1 + 2 * x2 <= 51, name="dollar_cost_per_hour_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Hank: {x1.varValue}")
    print(f"Hours worked by George: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
