
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="grams of carbohydrates")
    x1 = m.addVar(name="milligrams of vitamin B7")
    x2 = m.addVar(name="milligrams of calcium")


    # Set objective function
    obj = 3.05*x0**2 + 4.9*x0*x1 + 2.29*x0*x2 + 6.35*x1**2 + 5.97*x1*x2 + 7.42*x2**2 + 3.68*x0 + 5.63*x1 + 9.44*x2
    m.setObjective(obj, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7*x0 + 5*x1 + 6*x2 <= 131, "r0")
    m.addConstr(9*x0 + 16*x1 + 13*x2 <= 272, "r1")
    m.addConstr(14*x0 + 3*x1 + 23*x2 <= 211, "r2")
    m.addConstr(8*x0 + 26*x1 + 8*x2 <= 154, "r3")
    m.addConstr(5*x1 + 6*x2 >= 33, "c5")
    m.addConstr(7*x0 + 5*x1 >= 43, "c6")
    m.addConstr(7*x0**2 + 5*x1**2 + 6*x2**2 >= 31, "c7")
    m.addConstr(7*x0 + 5*x1 + 6*x2 >= 31, "c8")
    m.addConstr(9*x1**2 + 13*x2**2 >= 30, "c9")
    m.addConstr(9*x0**2 + 13*x2**2 >= 39, "c10")
    m.addConstr(9*x0 + 16*x1 + 13*x2 >= 67, "c11")
    m.addConstr(9*x0 + 16*x1 + 13*x2 >= 67, "c12")
    m.addConstr(14*x0**2 + 3*x1**2 >= 55, "c13")
    m.addConstr(14*x0**2 + 23*x2**2 >= 37, "c14")
    m.addConstr(14*x0 + 3*x1 + 23*x2 >= 37, "c15")
    m.addConstr(8*x0**2 + 26*x1**2 >= 34, "c16")
    m.addConstr(8*x0 + 8*x2 >= 42, "c17")
    m.addConstr(26*x1 + 8*x2 >= 47, "c18")
    m.addConstr(8*x0 + 26*x1 + 8*x2 >= 50, "c19")
    m.addConstr(8*x0 + 26*x1 + 8*x2 >= 50, "c20")
    m.addConstr(2*x0 - x2 >= 0, "c21")
    m.addConstr(4*x1 - 7*x2 >= 0, "c22")
    m.addConstr(7*x0 + 6*x2 <= 85, "c23")
    m.addConstr(7*x0 + 5*x1 <= 87, "c24")
    m.addConstr(16*x1 + 13*x2 <= 219, "c25")
    m.addConstr(9*x0 + 13*x2 <= 130, "c26")
    m.addConstr(3*x1 + 23*x2 <= 209, "c27")
    m.addConstr(14*x0 + 23*x2 <= 109, "c28")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
