
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="carbohydrates", lb=0)  # grams of carbohydrates
    x2 = model.addVar(name="vitamin_B7", lb=0)  # milligrams of vitamin B7
    x3 = model.addVar(name="calcium", lb=0)  # milligrams of calcium

    # Objective function
    model.setObjective(3.05*x1**2 + 4.9*x1*x2 + 2.29*x1*x3 + 6.35*x2**2 + 5.97*x2*x3 + 7.42*x3**2 + 3.68*x1 + 5.63*x2 + 9.44*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5*x2 + 6*x3 >= 33)
    model.addConstr(7*x1 + 5*x2 >= 43)
    model.addConstr(49*x1 + 25*x2 + 36*x3 >= 31)
    model.addConstr(7*x1 + 5*x2 + 6*x3 >= 31)
    model.addConstr(256*x2 + 169*x3 >= 30)
    model.addConstr(81*x1 + 169*x3 >= 39)
    model.addConstr(9*x1 + 16*x2 + 13*x3 >= 67)
    model.addConstr(196*x1 + 9*x2 >= 55)
    model.addConstr(196*x1 + 529*x3 >= 37)
    model.addConstr(14*x1 + 3*x2 + 23*x3 >= 37)
    model.addConstr(64*x1 + 676*x2 >= 34)
    model.addConstr(8*x1 + 8*x3 >= 42)
    model.addConstr(26*x2 + 8*x3 >= 47)
    model.addConstr(8*x1 + 26*x2 + 8*x3 >= 50)
    model.addConstr(2*x1 - x3 >= 0)
    model.addConstr(4*x2 - 7*x3 >= 0)
    model.addConstr(7*x1 + 6*x3 <= 85)
    model.addConstr(7*x1 + 5*x2 <= 87)
    model.addConstr(16*x2 + 13*x3 <= 219)
    model.addConstr(9*x1 + 13*x3 <= 130)
    model.addConstr(3*x2 + 23*x3 <= 209)
    model.addConstr(14*x1 + 23*x3 <= 109)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Carbohydrates: {x1.varValue}")
        print(f"Vitamin B7: {x2.varValue}")
        print(f"Calcium: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
