
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_allocation")

    # Create variables
    hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
    george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
    dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")


    # Set objective function
    model.setObjective(2*hank + 2*george + 2*dale, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4.99*hank + 1.66*george >= 28, "c1")
    model.addConstr(4.99*hank + 1.66*george + 3.73*dale >= 43, "c2")
    model.addConstr(1.76*george + 5.62*dale <= 64, "c3")
    model.addConstr(4.57*hank + 5.62*dale <= 59, "c4")
    model.addConstr(4.57*hank + 1.76*george + 5.62*dale <= 59, "c5")
    model.addConstr(4.99*hank + 1.66*george <= 124, "c6")
    model.addConstr(4.99*hank + 1.66*george + 3.73*dale <= 124, "c7")



    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('hank:', hank.x)
        print('george:', george.x)
        print('dale:', dale.x)

    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
        model.computeIIS()
        model.write("model.ilp")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
