
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Hank
    x1 = model.addVar(name="x1", lb=0)  # hours worked by George
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Dale

    # Define the objective function
    model.setObjective(2*x0 + 2*x1 + 2*x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(4.99*x0 + 1.66*x1 >= 28)
    model.addConstr(4.99*x0 + 1.66*x1 + 3.73*x2 >= 43)
    model.addConstr(1.76*x1 + 5.62*x2 <= 64)
    model.addConstr(4.57*x0 + 5.62*x2 <= 59)
    model.addConstr(4.57*x0 + 1.76*x1 + 5.62*x2 <= 59)
    model.addConstr(4.99*x0 + 1.66*x1 <= 124)
    model.addConstr(4.99*x0 + 1.66*x1 + 3.73*x2 <= 124)

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Hours worked by Hank:", x0.varValue)
        print("Hours worked by George:", x1.varValue)
        print("Hours worked by Dale:", x2.varValue)
        print("Objective function value:", model.objVal)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
