
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
x0 = model.addVar(vtype=GRB.INTEGER, name="dish_soap_bottles")
x1 = model.addVar(vtype=GRB.INTEGER, name="toilet_paper_rolls")
x2 = model.addVar(vtype=GRB.INTEGER, name="cartons_of_milk")
x3 = model.addVar(vtype=GRB.INTEGER, name="candles")
x4 = model.addVar(vtype=GRB.INTEGER, name="paper_towel_rolls")


# Set objective function
model.setObjective(3*x0 + 8*x1 + 4*x2 + x3 + 8*x4, GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x0 + 7*x1 + 19*x2 + 21*x3 + 5*x4 <= 436, "r0")
model.addConstr(5*x0 + 16*x1 + 19*x2 + 14*x3 + 11*x4 <= 198, "r1")
model.addConstr(5*x0 + 2*x1 + 11*x2 + x3 + 4*x4 <= 334, "r2")
model.addConstr(16*x0 + 5*x1 + 6*x2 + 11*x3 + 11*x4 <= 688, "r3")
model.addConstr(7*x1 + 5*x4 >= 51, "c5")
model.addConstr(19*x2 + 14*x3 >= 13, "c6")
model.addConstr(5*x0 + 11*x4 >= 19, "c7")
model.addConstr(14*x3 + 11*x4 >= 39, "c8")
model.addConstr(5*x0 + 14*x3 >= 28, "c9")
model.addConstr(16*x1 + 19*x2 >= 14, "c10")
model.addConstr(5*x0 + 19*x2 >= 32, "c11")
model.addConstr(19*x2 + 11*x4 >= 27, "c12")
model.addConstr(x3 + 4*x4 >= 30, "c13")
model.addConstr(5*x0 + 2*x1 + 11*x2 >= 48, "c30") # Strongest of the similar constraints
model.addConstr(2*x1 + x3 + 4*x4 >= 48, "c31") # Strongest of the similar constraints
model.addConstr(11*x2 + x3 + 4*x4 >= 48, "c32") # Strongest of the similar constraints
model.addConstr(5*x0 + x3 + 4*x4 >= 48, "c33") # Strongest of the similar constraints
model.addConstr(2*x1 + 11*x2 + x3 >= 48, "c34") # Strongest of the similar constraints
model.addConstr(2*x1 + 11*x2 + 4*x4 >= 48, "c35") # Strongest of the similar constraints
model.addConstr(5*x0 + 11*x2 + x3 >= 48, "c36") # Strongest of the similar constraints
model.addConstr(5*x1 + 6*x2 >= 63, "c70")
model.addConstr(16*x0 + 11*x4 >= 102, "c71")
model.addConstr(16*x0 + 5*x1 >= 109, "c72")
model.addConstr(x0 - 6*x3 >= 0, "c73")
model.addConstr(7*x1 + 5*x4 <= 344, "c74")
model.addConstr(7*x1 + 21*x3 <= 163, "c75")
model.addConstr(21*x3 + 5*x4 <= 282, "c76")
model.addConstr(10*x0 + 5*x4 <= 94, "c77")
model.addConstr(10*x0 + 19*x2 <= 143, "c78")
model.addConstr(19*x2 + 21*x3 <= 267, "c79")
model.addConstr(10*x0 + 7*x1 + 19*x2 + 21*x3 + 5*x4 <= 267, "c80")
model.addConstr(5*x0 + 19*x2 <= 56, "c81")
model.addConstr(19*x2 + 11*x4 <= 101, "c82")
model.addConstr(16*x1 + 19*x2 <= 179, "c83")
model.addConstr(16*x1 + 14*x3 <= 150, "c84")
model.addConstr(5*x0 + 11*x4 <= 103, "c85")
model.addConstr(19*x2 + 14*x3 + 11*x4 <= 112, "c86")
model.addConstr(5*x0 + 16*x1 + 11*x4 <= 195, "c87")
model.addConstr(16*x1 + 14*x3 + 11*x4 <= 51, "c88")
model.addConstr(5*x0 + 16*x1 + 19*x2 <= 176, "c89")
model.addConstr(5*x0 + 16*x1 + 19*x2 + 14*x3 + 11*x4 <= 176, "c90")
model.addConstr(5*x0 + 2*x1 <= 143, "c91")
model.addConstr(11*x2 + 4*x4 <= 276, "c92")
model.addConstr(5*x0 + x3 <= 176, "c93")
model.addConstr(5*x0 + 11*x2 <= 101, "c94")
model.addConstr(2*x1 + 4*x4 <= 134, "c95")
model.addConstr(2*x1 + x3 <= 262, "c96")
model.addConstr(5*x0 + 2*x1 + 11*x2 + x3 + 4*x4 <= 262, "c97")
model.addConstr(16*x0 + 5*x1 <= 520, "c98")
model.addConstr(6*x2 + 11*x3 <= 340, "c99")
model.addConstr(16*x0 + 11*x4 <= 405, "c100")
model.addConstr(16*x0 + 6*x2 <= 162, "c101")
model.addConstr(5*x1 + 11*x4 <= 144, "c102")
model.addConstr(6*x2 + 11*x4 <= 577, "c103")
model.addConstr(5*x1 + 6*x2 <= 286, "c104")
model.addConstr(5*x1 + 11*x3 <= 426, "c105")
model.addConstr(16*x0 + 11*x3 <= 245, "c106")
model.addConstr(16*x0 + 5*x1 + 6*x2 + 11*x3 + 11*x4 <= 245, "c107")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

