
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="x0") # milligrams of vitamin B3
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # grams of fiber


    # Set objective function
    m.setObjective(2*x0 + 8*x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4*x0 + 4*x1 >= 8, "c0")
    m.addConstr(5*x0 + 1*x1 >= 4, "c1")
    m.addConstr(4*x0 - 6*x1 >= 0, "c2")
    m.addConstr(4*x0 + 4*x1 <= 17, "c3")
    m.addConstr(5*x0 + 1*x1 <= 11, "c4")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        print("x0 (milligrams of vitamin B3):", x0.x)
        print("x1 (grams of fiber):", x1.x)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
