
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B3")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="grams_of_fiber")

# Set the objective function
m.setObjective(2*x0 + 8*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x0 + 4*x1 >= 8, "Immune_Support_Min")
m.addConstr(5*x0 + 1*x1 >= 4, "Kidney_Support_Min")
m.addConstr(4*x0 - 6*x1 >= 0, "Vitamin_Fiber_Constraint")
m.addConstr(4*x0 + 4*x1 <= 17, "Immune_Support_Max")
m.addConstr(5*x0 + 1*x1 <= 11, "Kidney_Support_Max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B3: {x0.x}")
    print(f"Grams of Fiber: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
