
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_fiber_optimization")

# Define variables
x1 = m.addVar(name="milligrams_of_vitamin_B3", vtype=gp.GRB.INTEGER)  # integer constraint
x2 = m.addVar(name="grams_of_fiber")

# Objective function: Maximize 2*x1 + 8*x2
m.setObjective(2*x1 + 8*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(4*x1 + 4*x2 >= 8, name="immune_support_min")
m.addConstr(5*x1 + x2 >= 4, name="kidney_support_min")
m.addConstr(4*x1 - 6*x2 >= 0, name="linear_constraint_1")
m.addConstr(4*x1 + 4*x2 <= 17, name="immune_support_max")
m.addConstr(5*x1 + x2 <= 11, name="kidney_support_max")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B3: {x1.varValue}")
    print(f"Grams of fiber: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
