
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="grams_of_protein")
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_K")


    # Set objective function
    m.setObjective(3*x0**2 + 2*x0*x1 + 9*x1**2 + 5*x0 + 2*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11*x0 + 10*x1 >= 23, "c0")
    m.addConstr(4*x0 + 4*x1 >= 37, "c1")
    m.addConstr(4*x0 + 7*x1 >= 22, "c2")
    m.addConstr(5*x0**2 - 8*x1**2 >= 0, "c3")
    m.addConstr(11*x0 + 10*x1 <= 55, "c4")
    m.addConstr(4*x0 + 4*x1 <= 66, "c5")
    m.addConstr(4*x0 + 7*x1 <= 59, "c6")



    # Optimize model
    m.optimize()

    # Print solution
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('grams_of_protein:', x0.x)
        print('milligrams_of_vitamin_K:', x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
