
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(vtype=gurobi.GRB.INTEGER, name="x1") # grams of protein
    x2 = model.addVar(vtype=gurobi.GRB.CONTINUOUS, name="x2") # milligrams of vitamin K

    # Objective function
    model.setObjective(3*x1**2 + 2*x1*x2 + 9*x2**2 + 5*x1 + 2*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 == 1, name="protein_constraint")
    model.addConstr(5*x1**2 - 8*x2**2 >= 0, name="stability_constraint")
    model.addConstr(121*x1**2 + 100*x2**2 >= 529, name="energy_stability_constraint")
    model.addConstr(11*x1 + 10*x2 >= 23, name="combined_energy_stability_constraint")
    model.addConstr(16*x1**2 + 16*x2**2 >= 1369, name="cardiovascular_support_constraint")
    model.addConstr(4*x1 + 4*x2 >= 37, name="combined_cardiovascular_support_constraint")
    model.addConstr(16*x1**2 + 49*x2**2 >= 484, name="digestive_support_constraint")
    model.addConstr(4*x1 + 7*x2 >= 22, name="combined_digestive_support_constraint")
    model.addConstr(121*x1**2 + 100*x2**2 <= 3025, name="max_energy_stability_constraint")
    model.addConstr(4*x1 + 4*x2 <= 66, name="max_cardiovascular_support_constraint")
    model.addConstr(16*x1**2 + 49*x2**2 <= 3481, name="max_digestive_support_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
