
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("vitamin_optimization")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="vitamin_K")
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_B2")
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_E")


    # Set objective function
    model.setObjective(1*x0 + 3*x1 + 8*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5.94*x1 + 6.47*x2 >= 54, "c0")
    model.addConstr(5.94*x0 + 13.89*x1 >= 27, "c1")
    model.addConstr(5.94*x0 + 13.89*x1 + 6.47*x2 >= 55, "c2")
    model.addConstr(4.83*x0 + 7.06*x1 >= 25, "c3")
    model.addConstr(4.83*x0 + 13.92*x2 >= 30, "c4")
    model.addConstr(7.06*x1 + 13.92*x2 >= 25, "c5")
    model.addConstr(4.83*x0 + 7.06*x1 + 13.92*x2 >= 25, "c6")
    model.addConstr(2*x1 - 6*x2 >= 0, "c7")
    model.addConstr(-3*x0 + 5*x1 >= 0, "c8")
    model.addConstr(5.94*x0 + 6.47*x2 <= 193, "c9")
    model.addConstr(7.06*x1 + 13.92*x2 <= 84, "c10")
    model.addConstr(4.83*x0 + 13.92*x2 <= 132, "c11")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Vitamin K:', x0.x)
        print('Vitamin B2:', x1.x)
        print('Vitamin E:', x2.x)

    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
