
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='milligrams_of_vitamin_K', vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name='milligrams_of_vitamin_B2')
    x2 = model.addVar(name='milligrams_of_vitamin_E')

    # Objective function
    model.setObjective(1*x0 + 3*x1 + 8*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(13.89*x1 + 6.47*x2 >= 54)
    model.addConstr(5.94*x0 + 13.89*x1 >= 27)
    model.addConstr(5.94*x0 + 13.89*x1 + 6.47*x2 >= 55)
    model.addConstr(4.83*x0 + 7.06*x1 >= 25)
    model.addConstr(4.83*x0 + 13.92*x2 >= 30)
    model.addConstr(7.06*x1 + 13.92*x2 >= 25)
    model.addConstr(4.83*x0 + 7.06*x1 + 13.92*x2 >= 25)
    model.addConstr(2*x1 - 6*x2 >= 0)
    model.addConstr(-3*x0 + 5*x1 >= 0)
    model.addConstr(5.94*x0 + 6.47*x2 <= 193)
    model.addConstr(7.06*x1 + 13.92*x2 <= 84)
    model.addConstr(4.83*x0 + 13.92*x2 <= 132)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('x0: ', x0.varValue)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
    else:
        print('The model is infeasible')

optimize_vitamins()
