
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize Organization Score")

# Create variables
hank_hours = model.addVar(name="hank_hours", lb=0)
peggy_hours = model.addVar(name="peggy_hours", lb=0)
paul_hours = model.addVar(name="paul_hours", lb=0)


# Set objective function
model.setObjective(3 * hank_hours + 6 * peggy_hours + 3 * paul_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(1 * hank_hours + 1 * peggy_hours >= 22, "combined_score_hank_peggy")
model.addConstr(1 * hank_hours + 1 * peggy_hours + 8 * paul_hours >= 19, "combined_score_all")
model.addConstr(1 * hank_hours + 8 * paul_hours <= 72, "combined_score_hank_paul")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print("Optimal Solution:")
    print(f"Hours worked by Hank: {hank_hours.x}")
    print(f"Hours worked by Peggy: {peggy_hours.x}")
    print(f"Hours worked by Paul: {paul_hours.x}")
    print(f"Objective Value: {model.objVal}")

