
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(lb=0, name="hours_worked_by_Hank")
x2 = m.addVar(lb=0, name="hours_worked_by_Peggy")
x3 = m.addVar(lb=0, name="hours_worked_by_Paul")

# Define the objective function
m.setObjective(3*x1 + 6*x2 + 3*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 22, "Hank_and_Peggy_score")
m.addConstr(x1 + x2 + 8*x3 >= 19, "Total_score")
m.addConstr(x1 + 8*x3 <= 72, "Hank_and_Paul_score")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hank works {x1.x} hours")
    print(f"Peggy works {x2.x} hours")
    print(f"Paul works {x3.x} hours")
else:
    print("No optimal solution found")

