
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Hank
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Peggy
    x3 = model.addVar(name='x3', lb=0)  # hours worked by Paul

    # Define the objective function
    model.setObjective(3*x1 + 6*x2 + 3*x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 >= 22)
    model.addConstr(x1 + x2 + 8*x3 >= 19)
    model.addConstr(x1 + 8*x3 <= 72)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Hank: {x1.varValue}')
        print(f'Hours worked by Peggy: {x2.varValue}')
        print(f'Hours worked by Paul: {x3.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
