
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # hours worked by Mary
    x1 = model.addVar(lb=0, vtype=GRB.INTEGER, name="x1") # hours worked by Hank
    x2 = model.addVar(lb=0, vtype=GRB.INTEGER, name="x2") # hours worked by Bill


    # Set objective function
    model.setObjective(2*x0*x1 + 2*x0*x2 + 6*x1**2 + x1*x2 + 6*x2**2 + 3*x0 + x2, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4.71*x0 <= 83, "c0")
    model.addConstr(0.15*x0 <= 34, "c1")
    model.addConstr(1.4*x1 <= 83, "c2")
    model.addConstr(1.39*x1 <= 34, "c3")
    model.addConstr(3.16*x2 <= 83, "c4")
    model.addConstr(4.51*x2 <= 34, "c5")
    model.addConstr(1.4*x1**2 + 3.16*x2**2 >= 12, "c6")
    model.addConstr(1.39*x1 + 4.51*x2 >= 6, "c7")
    model.addConstr(0.15*x0**2 + 1.39*x1**2 + 4.51*x2**2 >= 9, "c8")
    model.addConstr(1.4*x1 + 3.16*x2 <= 51, "c9")
    model.addConstr(4.71*x0 + 1.4*x1 <= 38, "c10")
    model.addConstr(4.71*x0 + 1.4*x1 + 3.16*x2 <= 38, "c11")
    model.addConstr(0.15*x0 + 4.51*x2 <= 27, "c12")
    model.addConstr(0.15*x0 + 1.39*x1 <= 17, "c13")
    model.addConstr(1.39*x1**2 + 4.51*x2**2 <= 17, "c14")
    model.addConstr(0.15*x0 + 1.39*x1 + 4.51*x2 <= 17, "c15")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
