
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
pickles = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")
chicken_thighs = m.addVar(lb=0, vtype=GRB.INTEGER, name="chicken_thighs")
strips_of_bacon = m.addVar(lb=0, vtype=GRB.INTEGER, name="strips_of_bacon")


# Set objective function
m.setObjective(2*pickles**2 + 4*pickles*chicken_thighs + 1*pickles*strips_of_bacon + 6*chicken_thighs**2 + 7*chicken_thighs*strips_of_bacon + 8*strips_of_bacon**2 + 5*pickles + 7*chicken_thighs + 3*strips_of_bacon, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.39*pickles + 6.83*chicken_thighs + 1.18*strips_of_bacon <= 122, "c0")
m.addConstr(0.34*pickles + 3.04*chicken_thighs + 6.13*strips_of_bacon <= 127, "c1")
m.addConstr(1.02*pickles + 2.81*chicken_thighs + 0.07*strips_of_bacon <= 89, "c2")
m.addConstr(4.7*pickles + 0.92*chicken_thighs + 2.52*strips_of_bacon <= 140, "c3")
m.addConstr(pickles**2 + chicken_thighs**2 + strips_of_bacon**2 >= 23, "c4")
m.addConstr(3.04*chicken_thighs + 6.13*strips_of_bacon >= 20, "c5")
m.addConstr(0.34*pickles + 6.13*strips_of_bacon >= 29, "c6")
m.addConstr(4.7*pickles**2 + 0.92*chicken_thighs**2 + 2.52*strips_of_bacon**2 >= 30, "c7")
m.addConstr(4*pickles - 4*strips_of_bacon >= 0, "c8")
m.addConstr(2.39*pickles**2 + 1.18*strips_of_bacon**2 <= 85, "c9")
m.addConstr(6.83*chicken_thighs**2 + 1.18*strips_of_bacon**2 <= 71, "c10")
m.addConstr(2.39*pickles**2 + 6.83*chicken_thighs**2 + 1.18*strips_of_bacon**2 <= 64, "c11")
m.addConstr(2.39*pickles + 6.83*chicken_thighs + 1.18*strips_of_bacon <= 64, "c12")
m.addConstr(0.34*pickles + 6.13*strips_of_bacon <= 95, "c13")
m.addConstr(3.04*chicken_thighs + 6.13*strips_of_bacon <= 96, "c14")
m.addConstr(0.34*pickles + 3.04*chicken_thighs + 6.13*strips_of_bacon <= 96, "c15")
m.addConstr(1.02*pickles**2 + 0.07*strips_of_bacon**2 <= 81, "c16")
m.addConstr(1.02*pickles + 2.81*chicken_thighs <= 86, "c17")
m.addConstr(1.02*pickles + 2.81*chicken_thighs + 0.07*strips_of_bacon <= 86, "c18")
m.addConstr(4.7*pickles**2 + 2.52*strips_of_bacon**2 <= 82, "c19")
m.addConstr(0.92*chicken_thighs**2 + 2.52*strips_of_bacon**2 <= 86, "c20")
m.addConstr(4.7*pickles + 0.92*chicken_thighs + 2.52*strips_of_bacon <= 86, "c21")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('pickles:', pickles.x)
    print('chicken_thighs:', chicken_thighs.x)
    print('strips_of_bacon:', strips_of_bacon.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

