
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_zinc_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b5") # milligrams of vitamin B5 (integer)
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="zinc") # milligrams of zinc (continuous)


    # Set objective function
    m.setObjective(5.62 * x0 + 5.08 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7 * x0 + 8 * x1 >= 11, "c0") # cardiovascular support index minimum
    m.addConstr(9 * x0 - 10 * x1 >= 0, "c1")  # constraint on vitamin B5 and zinc
    m.addConstr(7 * x0 + 8 * x1 <= 40, "c2") # cardiovascular support index maximum


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"milligrams of vitamin B5: {x0.x}")
        print(f"milligrams of zinc: {x1.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
