
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B5")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_zinc", lb=0)

# Set the objective function
m.setObjective(5.62*x1 + 5.08*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 8*x2 >= 11, "cardiovascular_support_index_min")
m.addConstr(9*x1 - 10*x2 >= 0, "vitamin_zinc_ratio")
m.addConstr(7*x1 + 8*x2 <= 40, "cardiovascular_support_index_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B5: {x1.x}")
    print(f"Milligrams of Zinc: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
