
import gurobi as gp

# Create a new model
model = gp.Model("optimization_problem")

# Define variables
x1 = model.addVar(vtype=gp.GRB.INTEGER, name="milligrams_of_vitamin_B5", lb=0)  # x1 is a non-negative integer
x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="milligrams_of_zinc", lb=0)  # x2 is a non-negative real number

# Objective function: maximize 5.62*x1 + 5.08*x2
model.setObjective(5.62*x1 + 5.08*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(7*x1 + 8*x2 >= 11, name="cardiovascular_support_index_min")
model.addConstr(7*x1 + 8*x2 <= 40, name="cardiovascular_support_index_max")
model.addConstr(9*x1 - 10*x2 >= 0, name="vitamin_zinc_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B5: {x1.varValue}")
    print(f"Milligrams of zinc: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
