
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    tomatoes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="tomatoes")
    bagged_salads = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
    fruit_salads = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
    pickles = m.addVar(vtype=gp.GRB.CONTINUOUS, name="pickles")


    # Set objective function
    m.setObjective(8*tomatoes + 4*bagged_salads + 1*fruit_salads + 8*pickles, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8*tomatoes + 1*bagged_salads + 15*fruit_salads + 21*pickles <= 363, "iron_upper_bound")
    m.addConstr(15*fruit_salads + 21*pickles >= 67, "fruit_salads_pickles_iron")
    m.addConstr(8*tomatoes + 21*pickles >= 40, "tomatoes_pickles_iron")
    m.addConstr(1*bagged_salads + 21*pickles >= 58, "bagged_salads_pickles_iron")
    m.addConstr(8*tomatoes + 1*bagged_salads >= 41, "tomatoes_bagged_salads_iron")
    m.addConstr(8*tomatoes + 1*bagged_salads + 21*pickles >= 56, "tomatoes_bagged_salads_pickles_iron")
    m.addConstr(8*tomatoes + 1*bagged_salads + 15*fruit_salads + 21*pickles >= 56, "total_iron")
    m.addConstr(-1*bagged_salads + 7*fruit_salads >= 0, "bagged_salads_fruit_salads_relation")
    m.addConstr(4*tomatoes - 9*bagged_salads >= 0, "tomatoes_bagged_salads_relation")
    m.addConstr(1*bagged_salads + 15*fruit_salads + 21*pickles <= 228, "bagged_salads_fruit_salads_pickles_iron")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
