
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    tomatoes = model.addVar(name="tomatoes", lb=0)  # Fractional amount allowed
    bagged_salads = model.addVar(name="bagged_salads", lb=0)  # Fractional amount allowed
    fruit_salads = model.addVar(name="fruit_salads", lb=0)  # Fractional amount allowed
    pickles = model.addVar(name="pickles", lb=0)  # Fractional amount allowed

    # Objective function
    model.setObjective(8 * tomatoes + 4 * bagged_salads + 1 * fruit_salads + 8 * pickles, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8 * tomatoes + 1 * bagged_salads + 15 * fruit_salads + 21 * pickles <= 363)
    model.addConstr(15 * fruit_salads + 21 * pickles >= 67)
    model.addConstr(8 * tomatoes + 21 * pickles >= 40)
    model.addConstr(1 * bagged_salads + 21 * pickles >= 58)
    model.addConstr(8 * tomatoes + 1 * bagged_salads >= 41)
    model.addConstr(8 * tomatoes + 1 * bagged_salads + 21 * pickles >= 56)
    model.addConstr(8 * tomatoes + 1 * bagged_salads + 15 * fruit_salads + 21 * pickles >= 56)
    model.addConstr(-1 * bagged_salads + 7 * fruit_salads >= 0)
    model.addConstr(4 * tomatoes - 9 * bagged_salads >= 0)
    model.addConstr(1 * bagged_salads + 15 * fruit_salads + 21 * pickles <= 228)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Tomatoes: ", tomatoes.varValue)
        print("Bagged Salads: ", bagged_salads.varValue)
        print("Fruit Salads: ", fruit_salads.varValue)
        print("Pickles: ", pickles.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
