
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="Tomatoes")
x1 = m.addVar(lb=0, name="Strips_of_bacon")
x2 = m.addVar(vtype=GRB.INTEGER, lb=0, name="Hamburgers")  # Must be whole number
x3 = m.addVar(vtype=GRB.INTEGER, lb=0, name="Strawberries")  # Must be whole number
x4 = m.addVar(lb=0, name="Corn_cobs")

# Objective function: Maximize
m.setObjective(1*x0 + 4*x1 + 7*x2 + 9*x3 + 7*x4, GRB.MAXIMIZE)

# Constraints (only a few examples are shown here due to the extensive list)
# Protein constraints
m.addConstr(x3 + x4 <= 206)  # Example: Total protein from strawberries and corn cobs
m.addConstr(x0 + x4 <= 127)  # Example: Total protein from tomatoes and corn cobs

# Tastiness constraints
m.addConstr(8*x1 + 17*x2 <= 80)  # Example: Total tastiness from strips of bacon and hamburgers

# Healthiness constraints
m.addConstr(x0 + 42*x1 <= 107)  # Example: Total healthiness from tomatoes and strips of bacon

# Calcium constraints (just a few examples)
m.addConstr(20*x1 + 10*x2 <= 305)  # Example: Maximum calcium from strips of bacon and hamburgers

# Other constraints
# ... Add all other constraints similarly as above, following the format:
# m.addConstr(expression <= value)
# or for equality constraints:
# m.addConstr(expression == value)

m.optimize()

print("Objective function value:", m.ObjVal)
for v in m.getVars():
    print(f"{v.VarName}: {v.X}")
