
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")  # grams of fat
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x1")  # milligrams of iron
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x2")  # grams of fiber

    # Objective function
    model.setObjective(5.49 * x0 + 5.92 * x1 + 3.77 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(15 * x1 + 8 * x2 >= 24, name="immune_support_index_constraint")
    model.addConstr(4 * x0 + 8 * x2 >= 23, name="immune_support_index_constraint_2")
    model.addConstr(4 * x0 + 15 * x1 + 8 * x2 >= 23, name="immune_support_index_constraint_3")
    model.addConstr(27 * x0 + 13 * x1 >= 32, name="muscle_growth_index_constraint")
    model.addConstr(13 * x1 + 3 * x2 >= 36, name="muscle_growth_index_constraint_2")
    model.addConstr(27 * x0 + 3 * x2 >= 31, name="muscle_growth_index_constraint_3")
    model.addConstr(27 * x0 + 13 * x1 + 3 * x2 >= 31, name="muscle_growth_index_constraint_4")
    model.addConstr(29 * x0 + 28 * x2 >= 50, name="cardiovascular_support_index_constraint")
    model.addConstr(29 * x0 + 5 * x1 >= 44, name="cardiovascular_support_index_constraint_2")
    model.addConstr(29 * x0 + 5 * x1 + 28 * x2 >= 44, name="cardiovascular_support_index_constraint_3")
    model.addConstr(-9 * x1 + 8 * x2 >= 0, name="linear_constraint")
    model.addConstr(2 * x0 - x2 >= 0, name="linear_constraint_2")
    model.addConstr(29 * x0 + 28 * x2 <= 79, name="linear_constraint_3")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Objective: {model.objval}")
        print(f"Grams of fat: {x0.varValue}")
        print(f"Milligrams of iron: {x1.varValue}")
        print(f"Grams of fiber: {x2.varValue}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
