
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="slices of pizza")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")


# Set objective function
m.setObjective(7*x0 + 4*x1 + 3*x2 + 7*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x0 + 3*x1 + 6*x2 + 3*x3 <= 122, "r0")
m.addConstr(1*x0 + 3*x1 + 7*x2 + 6*x3 <= 80, "r1")
m.addConstr(3*x1 + 6*x2 >= 22)
m.addConstr(3*x1 + 3*x3 >= 14)
m.addConstr(11*x0 + 3*x3 >= 18)
m.addConstr(11*x0 + 6*x2 >= 11)
m.addConstr(6*x2 + 3*x3 >= 22)
m.addConstr(11*x0 + 6*x2 + 3*x3 >= 24)
m.addConstr(11*x0 + 3*x1 + 6*x2 >= 24)
m.addConstr(3*x1 + 6*x2 + 3*x3 >= 24)
m.addConstr(11*x0 + 6*x2 + 3*x3 >= 18)
m.addConstr(11*x0 + 3*x1 + 6*x2 >= 18)
m.addConstr(3*x1 + 6*x2 + 3*x3 >= 18)
m.addConstr(11*x0 + 6*x2 + 3*x3 >= 20)
m.addConstr(11*x0 + 3*x1 + 6*x2 >= 20)
m.addConstr(3*x1 + 6*x2 + 3*x3 >= 20)
m.addConstr(3*x1 + 6*x3 >= 17)
m.addConstr(7*x2 + 6*x3 >= 6)
m.addConstr(1*x0 + 3*x1 >= 19)
m.addConstr(3*x1 + 7*x2 >= 9)
m.addConstr(3*x1 + 7*x2 + 6*x3 >= 13)
m.addConstr(3*x1 + 3*x3 <= 121)
m.addConstr(3*x1 + 6*x2 <= 111)
m.addConstr(11*x0 + 3*x1 <= 47)
m.addConstr(11*x0 + 3*x3 <= 115)
m.addConstr(6*x2 + 3*x3 <= 30)
m.addConstr(11*x0 + 6*x2 <= 54)
m.addConstr(11*x0 + 3*x1 + 6*x2 <= 94)
m.addConstr(11*x0 + 3*x1 + 6*x2 + 3*x3 <= 94)
m.addConstr(3*x1 + 7*x2 <= 51)
m.addConstr(1*x0 + 6*x3 <= 58)
m.addConstr(3*x1 + 7*x2 + 6*x3 <= 29)
m.addConstr(1*x0 + 3*x1 + 7*x2 + 6*x3 <= 29)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

