
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    carbs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbs")
    b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="b12")
    vit_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vit_k")

    # Set objective function
    m.setObjective(9*carbs + 5*b12 + 2*vit_k, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2*carbs + 4*b12 + 3*vit_k >= 21, "c1")
    m.addConstr(2*carbs + 3*vit_k >= 27, "c2")
    m.addConstr(2*carbs + 4*b12 >= 23, "c3")
    m.addConstr(2*carbs + 4*b12 + 3*vit_k >= 23, "c4")
    m.addConstr(8*b12 + 4*vit_k >= 9, "c5")
    m.addConstr(5*carbs + 8*b12 >= 17, "c6")
    m.addConstr(5*carbs + 8*b12 + 4*vit_k >= 17, "c7")
    m.addConstr(4*carbs - 7*vit_k >= 0, "c8")
    m.addConstr(4*b12 - vit_k >= 0, "c9")
    m.addConstr(5*carbs + 8*b12 + 4*vit_k <= 61, "c10")
    m.addConstr(2*carbs + 4*b12 + 3*vit_k <= 89, "c11") # Added upper bound constraint for cognitive performance
    m.addConstr(5*carbs + 8*b12 + 4*vit_k <= 63, "c12") # Added upper bound constraint for digestive support


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('carbs:', carbs.x)
        print('b12:', b12.x)
        print('vit_k:', vit_k.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
