
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # grams of carbohydrates
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B12
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin K

    # Objective function
    model.setObjective(9 * x0 + 5 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x0 <= 89)
    model.addConstr(5 * x0 <= 63)
    model.addConstr(4 * x1 <= 89)
    model.addConstr(8 * x1 <= 63)
    model.addConstr(3 * x2 <= 89)
    model.addConstr(4 * x2 <= 63)
    model.addConstr(4 * x1 + 3 * x2 >= 21)
    model.addConstr(2 * x0 + 3 * x2 >= 27)
    model.addConstr(2 * x0 + 4 * x1 >= 23)
    model.addConstr(2 * x0 + 4 * x1 + 3 * x2 >= 23)
    model.addConstr(8 * x1 + 4 * x2 >= 9)
    model.addConstr(5 * x0 + 8 * x1 >= 17)
    model.addConstr(5 * x0 + 8 * x1 + 4 * x2 >= 17)
    model.addConstr(4 * x0 - 7 * x2 >= 0)
    model.addConstr(4 * x1 - x2 >= 0)
    model.addConstr(5 * x0 + 8 * x1 + 4 * x2 <= 61)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Objective: {model.objVal}")
        print(f"Grams of carbohydrates: {x0.varValue}")
        print(f"Milligrams of vitamin B12: {x1.varValue}")
        print(f"Milligrams of vitamin K: {x2.varValue}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
