
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")


# Set objective function
m.setObjective(4 * vitamin_a + 1 * vitamin_b12 + 5 * potassium + 9 * zinc + 4 * vitamin_b9, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * vitamin_b12 + 4 * potassium >= 8)
m.addConstr(4 * potassium + 2 * vitamin_b9 >= 6)
m.addConstr(zinc + 2 * vitamin_b9 >= 10)
m.addConstr(8 * vitamin_a + vitamin_b12 >= 16)
m.addConstr(8 * vitamin_a + 2 * vitamin_b9 >= 14)
m.addConstr(4 * potassium + zinc >= 10)
m.addConstr(8 * vitamin_a + vitamin_b12 + 4 * potassium >= 15)
m.addConstr(8 * vitamin_a + zinc + 2 * vitamin_b9 >= 15)
m.addConstr(8 * vitamin_a + 4 * potassium + 2 * vitamin_b9 >= 15)
m.addConstr(8 * vitamin_a + vitamin_b12 + zinc >= 15)

m.addConstr(vitamin_a + 3 * zinc >= 14)
m.addConstr(3 * potassium + 3 * vitamin_b9 >= 18)
m.addConstr(3 * potassium + 4 * zinc >= 10)
m.addConstr(vitamin_a + 3 * potassium >= 16)
m.addConstr(vitamin_a + 3 * vitamin_b12 >= 16)
m.addConstr(4 * zinc + 3 * vitamin_b9 >= 16)
m.addConstr(3 * vitamin_b12 + 4 * zinc >= 16)

m.addConstr(vitamin_a + 8 * vitamin_b12 >= 12)
m.addConstr(8 * vitamin_b12 + 5 * vitamin_b9 >= 7)
m.addConstr(vitamin_a + 5 * vitamin_b9 >= 8)
m.addConstr(vitamin_a + 8 * potassium >= 9)
m.addConstr(vitamin_a + 6 * zinc >= 14)
m.addConstr(8 * vitamin_b12 + 6 * zinc >= 7)


m.addConstr(10 * vitamin_b12 - 9 * potassium >= 0)
m.addConstr(zinc + 2 * vitamin_b9 <= 87)
m.addConstr(4 * potassium + zinc <= 44)
m.addConstr(vitamin_b12 + 4 * potassium <= 84)
m.addConstr(8 * vitamin_a + vitamin_b12 <= 59)
m.addConstr(4 * potassium + 2 * vitamin_b9 <= 98)
m.addConstr(vitamin_b12 + 2 * vitamin_b9 <= 76)
m.addConstr(8 * vitamin_a + 4 * potassium + zinc <= 76)
m.addConstr(vitamin_a + 3 * vitamin_b12 <= 81)
m.addConstr(4 * zinc + 3 * vitamin_b9 <= 49)
m.addConstr(3 * potassium + 3 * vitamin_b9 <= 31)
m.addConstr(3 * potassium + 4 * zinc <= 75)
m.addConstr(vitamin_a + 3 * potassium <= 96)
m.addConstr(vitamin_a + 3 * vitamin_b12 + 4 * zinc <= 57)
m.addConstr(vitamin_a + 8 * potassium <= 71)
m.addConstr(8 * vitamin_b12 + 8 * potassium <= 67)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

