
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
coleus = m.addVar(vtype=gp.GRB.INTEGER, name="coleus")
carrots = m.addVar(vtype=gp.GRB.INTEGER, name="carrots")
tulips = m.addVar(vtype=gp.GRB.INTEGER, name="tulips")
decorative_cabbages = m.addVar(vtype=gp.GRB.INTEGER, name="decorative_cabbages")


# Set objective function
m.setObjective(4.71 * coleus + 4.67 * carrots + 7.23 * tulips + 8.21 * decorative_cabbages, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(12 * coleus + 11 * carrots >= 63)
m.addConstr(12 * coleus + 2 * tulips >= 71)
m.addConstr(2 * tulips + 20 * decorative_cabbages >= 49)
m.addConstr(11 * carrots + 2 * tulips >= 33)
m.addConstr(11 * carrots + 20 * decorative_cabbages >= 39)
m.addConstr(12 * coleus + 11 * carrots + 2 * tulips >= 58)
m.addConstr(12 * coleus + 2 * tulips + 20 * decorative_cabbages >= 58)
m.addConstr(11 * carrots + 2 * tulips + 20 * decorative_cabbages >= 58)
m.addConstr(12 * coleus + 11 * carrots + 2 * tulips >= 65)
m.addConstr(12 * coleus + 2 * tulips + 20 * decorative_cabbages >= 65)
m.addConstr(11 * carrots + 2 * tulips + 20 * decorative_cabbages >= 65)
m.addConstr(12 * coleus + 11 * carrots + 2 * tulips >= 42)
m.addConstr(12 * coleus + 2 * tulips + 20 * decorative_cabbages >= 42)
m.addConstr(11 * carrots + 2 * tulips + 20 * decorative_cabbages >= 42)
m.addConstr(12 * coleus + 11 * carrots + 2 * tulips + 20 * decorative_cabbages >= 42)
m.addConstr(10 * tulips + 5 * decorative_cabbages >= 97)
m.addConstr(6 * carrots + 5 * decorative_cabbages >= 86)
m.addConstr(18 * coleus + 6 * carrots >= 86)
m.addConstr(18 * coleus + 6 * carrots + 10 * tulips + 5 * decorative_cabbages >= 86)
m.addConstr(6 * carrots - 3 * tulips >= 0)
m.addConstr(11 * carrots + 2 * tulips <= 110)
m.addConstr(2 * tulips + 20 * decorative_cabbages <= 215)
m.addConstr(12 * coleus + 11 * carrots <= 129)
m.addConstr(10 * tulips + 5 * decorative_cabbages <= 121)
m.addConstr(6 * carrots + 10 * tulips <= 364)
m.addConstr(18 * coleus + 6 * carrots + 5 * decorative_cabbages <= 231)
m.addConstr(18 * coleus + 10 * tulips + 5 * decorative_cabbages <= 249)
m.addConstr(18 * coleus + 6 * carrots + 10 * tulips <= 173)
m.addConstr(6 * carrots + 10 * tulips + 5 * decorative_cabbages <= 191)

m.addConstr(12 * coleus <= 287)
m.addConstr(18 * coleus <= 402)



# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
