
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='coleus', vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name='carrots', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='tulips', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='decorative_cabbages', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(4.71 * x0 + 4.67 * x1 + 7.23 * x2 + 8.21 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12 * x0 <= 287)
    model.addConstr(18 * x0 <= 402)
    model.addConstr(11 * x1 <= 287)
    model.addConstr(6 * x1 <= 402)
    model.addConstr(2 * x2 <= 287)
    model.addConstr(10 * x2 <= 402)
    model.addConstr(20 * x3 <= 287)
    model.addConstr(5 * x3 <= 402)
    model.addConstr(12 * x0 + 11 * x1 >= 63)
    model.addConstr(12 * x0 + 2 * x2 >= 71)
    model.addConstr(2 * x2 + 20 * x3 >= 49)
    model.addConstr(11 * x1 + 2 * x2 >= 33)
    model.addConstr(11 * x1 + 20 * x3 >= 39)
    model.addConstr(12 * x0 + 11 * x1 + 2 * x2 >= 58)
    model.addConstr(12 * x0 + 2 * x2 + 20 * x3 >= 58)
    model.addConstr(11 * x1 + 2 * x2 + 20 * x3 >= 58)
    model.addConstr(12 * x0 + 11 * x1 + 2 * x2 >= 65)
    model.addConstr(12 * x0 + 2 * x2 + 20 * x3 >= 65)
    model.addConstr(11 * x1 + 2 * x2 + 20 * x3 >= 65)
    model.addConstr(12 * x0 + 11 * x1 + 2 * x2 >= 42)
    model.addConstr(12 * x0 + 2 * x2 + 20 * x3 >= 42)
    model.addConstr(11 * x1 + 2 * x2 + 20 * x3 >= 42)
    model.addConstr(12 * x0 + 11 * x1 + 2 * x2 + 20 * x3 >= 42)
    model.addConstr(10 * x2 + 5 * x3 >= 97)
    model.addConstr(6 * x1 + 5 * x3 >= 86)
    model.addConstr(18 * x0 + 6 * x1 >= 86)
    model.addConstr(18 * x0 + 6 * x1 + 10 * x2 + 5 * x3 >= 86)
    model.addConstr(6 * x1 - 3 * x2 >= 0)
    model.addConstr(11 * x1 + 2 * x2 <= 110)
    model.addConstr(2 * x2 + 20 * x3 <= 215)
    model.addConstr(12 * x0 + 11 * x1 <= 129)
    model.addConstr(10 * x2 + 5 * x3 <= 121)
    model.addConstr(6 * x1 + 10 * x2 <= 364)
    model.addConstr(18 * x0 + 6 * x1 + 5 * x3 <= 231)
    model.addConstr(18 * x0 + 10 * x2 + 5 * x3 <= 249)
    model.addConstr(18 * x0 + 6 * x1 + 10 * x2 <= 173)
    model.addConstr(6 * x1 + 10 * x2 + 5 * x3 <= 191)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Coleus: ', x0.varValue)
        print('Carrots: ', x1.varValue)
        print('Tulips: ', x2.varValue)
        print('Decorative Cabbages: ', x3.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
