
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
knishes = m.addVar(vtype=gp.GRB.INTEGER, name="knishes")
strawberries = m.addVar(vtype=gp.GRB.INTEGER, name="strawberries")
ravioli = m.addVar(vtype=gp.GRB.INTEGER, name="ravioli")
chicken_thighs = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_thighs")

# Set objective function
m.setObjective(8*knishes + 8*strawberries + 6*ravioli + 9*chicken_thighs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9*knishes + 32*strawberries >= 87, "fiber_knishes_strawberries")
m.addConstr(5*ravioli + 18*chicken_thighs >= 43, "fiber_ravioli_chicken_thighs")
m.addConstr(9*knishes + 5*ravioli >= 52, "fiber_knishes_ravioli")
m.addConstr(9*knishes + 32*strawberries + 5*ravioli >= 56, "fiber_knishes_strawberries_ravioli")
m.addConstr(9*knishes + 32*strawberries + 5*ravioli + 18*chicken_thighs >= 56, "fiber_all")
m.addConstr(16*knishes + 27*chicken_thighs >= 66, "protein_knishes_chicken_thighs")
m.addConstr(16*knishes + 17*strawberries >= 63, "protein_knishes_strawberries")
m.addConstr(27*ravioli + 27*chicken_thighs >= 30, "protein_ravioli_chicken_thighs")
m.addConstr(16*knishes + 17*strawberries + 27*ravioli >= 79, "protein_knishes_strawberries_ravioli")
m.addConstr(16*knishes + 17*strawberries + 27*ravioli + 27*chicken_thighs >= 79, "protein_all")
m.addConstr(19*knishes + 15*ravioli >= 56, "sourness_knishes_ravioli")
m.addConstr(13*strawberries + 12*chicken_thighs >= 83, "sourness_strawberries_chicken_thighs")
m.addConstr(19*knishes + 13*strawberries + 12*chicken_thighs >= 81, "sourness_knishes_strawberries_chicken_thighs")
m.addConstr(19*knishes + 13*strawberries + 15*ravioli + 12*chicken_thighs >= 81, "sourness_all")
m.addConstr(4*strawberries - 10*chicken_thighs >= 0, "strawberries_chicken_thighs_relation")

m.addConstr(9*knishes + 5*ravioli <= 219, "fiber_knishes_ravioli_ub")
m.addConstr(32*strawberries + 5*ravioli <= 355, "fiber_strawberries_ravioli_ub")
m.addConstr(9*knishes + 32*strawberries + 18*chicken_thighs <= 183, "fiber_knishes_strawberries_chicken_thighs_ub")
m.addConstr(9*knishes + 5*ravioli + 18*chicken_thighs <= 317, "fiber_knishes_ravioli_chicken_thighs_ub")
m.addConstr(9*knishes + 32*strawberries + 5*ravioli <= 319, "fiber_knishes_strawberries_ravioli_ub")
m.addConstr(16*knishes + 27*chicken_thighs <= 207, "protein_knishes_chicken_thighs_ub")
m.addConstr(17*strawberries + 27*ravioli + 27*chicken_thighs <= 269, "protein_strawberries_ravioli_chicken_thighs_ub")
m.addConstr(19*knishes + 15*ravioli <= 221, "sourness_knishes_ravioli_ub")
m.addConstr(19*knishes + 15*ravioli + 12*chicken_thighs <= 124, "sourness_knishes_ravioli_chicken_thighs_ub")
m.addConstr(19*knishes + 13*strawberries + 12*chicken_thighs <= 344, "sourness_knishes_strawberries_chicken_thighs_ub")
m.addConstr(19*knishes + 13*strawberries + 15*ravioli <= 351, "sourness_knishes_strawberries_ravioli_ub")
m.addConstr(13*strawberries + 15*ravioli + 12*chicken_thighs <= 258, "sourness_strawberries_ravioli_chicken_thighs_ub")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

