
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    knishes = model.addVar(name="knishes", vtype=gurobi.GRB.INTEGER)
    strawberries = model.addVar(name="strawberries", vtype=gurobi.GRB.INTEGER)
    ravioli = model.addVar(name="ravioli", vtype=gurobi.GRB.INTEGER)
    chicken_thighs = model.addVar(name="chicken_thighs", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8 * knishes + 8 * strawberries + 6 * ravioli + 9 * chicken_thighs, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9 * knishes + 32 * strawberries + 5 * ravioli + 18 * chicken_thighs <= 439)
    model.addConstr(16 * knishes + 17 * strawberries + 27 * ravioli + 27 * chicken_thighs <= 362)
    model.addConstr(19 * knishes + 13 * strawberries + 15 * ravioli + 12 * chicken_thighs <= 368)
    model.addConstr(9 * knishes + 32 * strawberries >= 87)
    model.addConstr(5 * ravioli + 18 * chicken_thighs >= 43)
    model.addConstr(9 * knishes + 5 * ravioli >= 52)
    model.addConstr(9 * knishes + 32 * strawberries + 5 * ravioli >= 56)
    model.addConstr(9 * knishes + 32 * strawberries + 5 * ravioli + 18 * chicken_thighs >= 56)
    model.addConstr(16 * knishes + 27 * chicken_thighs >= 66)
    model.addConstr(16 * knishes + 17 * strawberries >= 63)
    model.addConstr(27 * ravioli + 27 * chicken_thighs >= 30)
    model.addConstr(16 * knishes + 17 * strawberries + 27 * ravioli >= 79)
    model.addConstr(16 * knishes + 17 * strawberries + 27 * ravioli + 27 * chicken_thighs >= 79)
    model.addConstr(19 * knishes + 15 * ravioli >= 56)
    model.addConstr(13 * strawberries + 12 * chicken_thighs >= 83)
    model.addConstr(19 * knishes + 13 * strawberries + 12 * chicken_thighs >= 81)
    model.addConstr(19 * knishes + 13 * strawberries + 15 * ravioli + 12 * chicken_thighs >= 81)
    model.addConstr(4 * strawberries - 10 * chicken_thighs >= 0)
    model.addConstr(9 * knishes + 5 * ravioli <= 219)
    model.addConstr(32 * strawberries + 5 * ravioli <= 355)
    model.addConstr(9 * knishes + 32 * strawberries + 18 * chicken_thighs <= 183)
    model.addConstr(9 * knishes + 5 * ravioli + 18 * chicken_thighs <= 317)
    model.addConstr(9 * knishes + 32 * strawberries + 5 * ravioli <= 319)
    model.addConstr(16 * knishes + 27 * chicken_thighs <= 207)
    model.addConstr(17 * strawberries + 27 * ravioli + 27 * chicken_thighs <= 269)
    model.addConstr(19 * knishes + 15 * ravioli <= 221)
    model.addConstr(19 * knishes + 15 * ravioli + 12 * chicken_thighs <= 124)
    model.addConstr(19 * knishes + 13 * strawberries + 12 * chicken_thighs <= 344)
    model.addConstr(19 * knishes + 13 * strawberries + 15 * ravioli <= 351)
    model.addConstr(13 * strawberries + 15 * ravioli + 12 * chicken_thighs <= 258)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Knishes: ", knishes.varValue)
        print("Strawberries: ", strawberries.varValue)
        print("Ravioli: ", ravioli.varValue)
        print("Chicken Thighs: ", chicken_thighs.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
