
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name=["John", "Jean", "Ringo", "George", "Bobby"])


# Set objective
m.setObjective(4*x[0]**2 + 9*x[0]*x[1] + 4*x[0]*x[2] + 6*x[0]*x[4] + 9*x[1]*x[2] + 9*x[1]*x[3] + 9*x[2]*x[3] + 2*x[3]*x[4] + 4*x[4]**2 + x[0] + 2*x[1] + 4*x[2] + 2*x[3] + 9*x[4], gp.GRB.MINIMIZE)

# Add constraints

#likelihood to quit index constraints
m.addConstr(13.68*x[2]**2 + 13.21*x[3]**2 >= 106)
m.addConstr(13.68*x[0] + 9.72*x[2] >= 57)


# Add other constraints similarly based on the JSON output


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

