
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin E
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B5
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # grams of carbohydrates
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin K


    # Set objective function
    m.setObjective(2*x0 + 3*x1 + 6*x2 + 8*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3*x0 + 13*x1 + 12*x2 + 9*x3 <= 177)
    m.addConstr(11*x0 + 6*x1 + 16*x2 + 6*x3 <= 305)
    m.addConstr(1*x0 + 4*x1 + 5*x2 + 16*x3 <= 367)
    m.addConstr(3*x0 + 12*x2 >= 30)
    m.addConstr(3*x0 + 13*x1 >= 35)
    m.addConstr(12*x2 + 9*x3 >= 36)
    m.addConstr(13*x1 + 12*x2 >= 31)
    m.addConstr(3*x0 + 13*x1 + 9*x3 >= 34)
    m.addConstr(13*x1 + 12*x2 + 9*x3 >= 34)
    m.addConstr(3*x0 + 13*x1 + 12*x2 >= 34)
    m.addConstr(3*x0 + 13*x1 + 9*x3 >= 29)
    m.addConstr(13*x1 + 12*x2 + 9*x3 >= 29)
    m.addConstr(3*x0 + 13*x1 + 12*x2 >= 29)
    m.addConstr(3*x0 + 13*x1 + 9*x3 >= 43)
    m.addConstr(13*x1 + 12*x2 + 9*x3 >= 43)
    m.addConstr(3*x0 + 13*x1 + 12*x2 >= 43)
    m.addConstr(3*x0 + 13*x1 + 12*x2 + 9*x3 >= 43)
    m.addConstr(11*x0 + 16*x2 >= 32)
    m.addConstr(11*x0 + 6*x3 >= 69)
    m.addConstr(6*x1 + 16*x2 >= 35)
    m.addConstr(11*x0 + 6*x1 + 6*x3 >= 59)
    m.addConstr(11*x0 + 6*x1 + 16*x2 + 6*x3 >= 59)
    m.addConstr(x0 + 4*x1 >= 71)
    m.addConstr(x0 + 5*x2 >= 68)
    m.addConstr(5*x2 + 16*x3 >= 69)
    m.addConstr(x0 + 4*x1 + 5*x2 + 16*x3 >= 69)
    m.addConstr(5*x2 - 7*x3 >= 0)
    m.addConstr(4*x1 - 3*x2 >= 0)
    m.addConstr(3*x0 + 13*x1 + 9*x3 <= 165)
    m.addConstr(13*x1 + 12*x2 + 9*x3 <= 50)
    m.addConstr(3*x0 + 12*x2 + 9*x3 <= 149)
    m.addConstr(6*x1 + 6*x3 <= 137)
    m.addConstr(11*x0 + 16*x2 <= 116)
    m.addConstr(11*x0 + 6*x3 <= 106)
    m.addConstr(11*x0 + 16*x2 + 6*x3 <= 249)
    m.addConstr(6*x1 + 16*x2 + 6*x3 <= 160)
    m.addConstr(4*x1 + 5*x2 <= 335)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
