
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin E
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B5
    x2 = model.addVar(name="x2", lb=0)  # grams of carbohydrates
    x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin K

    # Objective function
    model.setObjective(2 * x0 + 3 * x1 + 6 * x2 + 8 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x0 <= 177)
    model.addConstr(11 * x0 <= 305)
    model.addConstr(x0 <= 367)
    model.addConstr(13 * x1 <= 177)
    model.addConstr(6 * x1 <= 305)
    model.addConstr(4 * x1 <= 367)
    model.addConstr(12 * x2 <= 177)
    model.addConstr(16 * x2 <= 305)
    model.addConstr(5 * x2 <= 367)
    model.addConstr(9 * x3 <= 177)
    model.addConstr(6 * x3 <= 305)
    model.addConstr(16 * x3 <= 367)
    model.addConstr(3 * x0 + 12 * x2 >= 30)
    model.addConstr(3 * x0 + 13 * x1 >= 35)
    model.addConstr(12 * x2 + 9 * x3 >= 36)
    model.addConstr(13 * x1 + 12 * x2 >= 31)
    model.addConstr(3 * x0 + 13 * x1 + 9 * x3 >= 34)
    model.addConstr(13 * x1 + 12 * x2 + 9 * x3 >= 34)
    model.addConstr(3 * x0 + 13 * x1 + 12 * x2 >= 34)
    model.addConstr(3 * x0 + 13 * x1 + 9 * x3 >= 29)
    model.addConstr(13 * x1 + 12 * x2 + 9 * x3 >= 29)
    model.addConstr(3 * x0 + 13 * x1 + 12 * x2 >= 29)
    model.addConstr(3 * x0 + 13 * x1 + 9 * x3 >= 43)
    model.addConstr(13 * x1 + 12 * x2 + 9 * x3 >= 43)
    model.addConstr(3 * x0 + 13 * x1 + 12 * x2 >= 43)
    model.addConstr(3 * x0 + 13 * x1 + 12 * x2 + 9 * x3 >= 43)
    model.addConstr(11 * x0 + 16 * x2 >= 32)
    model.addConstr(11 * x0 + 6 * x3 >= 69)
    model.addConstr(6 * x1 + 16 * x2 >= 35)
    model.addConstr(11 * x0 + 6 * x1 + 6 * x3 >= 59)
    model.addConstr(11 * x0 + 6 * x1 + 16 * x2 + 6 * x3 >= 59)
    model.addConstr(x0 + 4 * x1 >= 71)
    model.addConstr(x0 + 5 * x2 >= 68)
    model.addConstr(5 * x2 + 16 * x3 >= 69)
    model.addConstr(x0 + 4 * x1 + 5 * x2 + 16 * x3 >= 69)
    model.addConstr(5 * x2 - 7 * x3 >= 0)
    model.addConstr(4 * x1 - 3 * x2 >= 0)
    model.addConstr(3 * x0 + 13 * x1 + 9 * x3 <= 165)
    model.addConstr(13 * x1 + 12 * x2 + 9 * x3 <= 50)
    model.addConstr(3 * x0 + 12 * x2 + 9 * x3 <= 149)
    model.addConstr(6 * x1 + 6 * x3 <= 137)
    model.addConstr(11 * x0 + 16 * x2 <= 116)
    model.addConstr(11 * x0 + 6 * x3 <= 106)
    model.addConstr(11 * x0 + 16 * x2 + 6 * x3 <= 249)
    model.addConstr(6 * x1 + 16 * x2 + 6 * x3 <= 160)
    model.addConstr(4 * x1 + 5 * x2 <= 335)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"milligrams of vitamin E: {x0.varValue}")
        print(f"milligrams of vitamin B5: {x1.varValue}")
        print(f"grams of carbohydrates: {x2.varValue}")
        print(f"milligrams of vitamin K: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
