
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    fiber = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fiber")
    vitamin_b5 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")
    vitamin_e = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_e")

    # Set objective function
    m.setObjective(5*fiber + 3*vitamin_b5 + 8*vitamin_e, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2*vitamin_b5 + 9*vitamin_e >= 16, "c1")
    m.addConstr(8*fiber + 2*vitamin_b5 + 9*vitamin_e >= 16, "c2")
    m.addConstr(vitamin_b5 + 5*vitamin_e >= 8, "c3")
    m.addConstr(7*fiber + vitamin_b5 >= 14, "c4")
    m.addConstr(7*fiber + vitamin_b5 + 5*vitamin_e >= 14, "c5")
    m.addConstr(-fiber + 5*vitamin_b5 >= 0, "c6")
    m.addConstr(8*fiber + 9*vitamin_e <= 30, "c7")
    m.addConstr(2*vitamin_b5 + 9*vitamin_e <= 47, "c8")
    m.addConstr(8*fiber + 2*vitamin_b5 <= 43, "c9")
    m.addConstr(8*fiber + 2*vitamin_b5 + 9*vitamin_e <= 29, "c10")
    m.addConstr(7*fiber + vitamin_b5 <= 27, "c11")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('fiber:', fiber.x)
        print('vitamin_b5:', vitamin_b5.x)
        print('vitamin_e:', vitamin_e.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
