
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # grams of fiber
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B5
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin E

    # Objective function
    model.setObjective(5 * x0 + 3 * x1 + 8 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x1 + 9 * x2 >= 16)
    model.addConstr(8 * x0 + 2 * x1 + 9 * x2 >= 16)
    model.addConstr(x1 + 5 * x2 >= 8)
    model.addConstr(7 * x0 + x1 >= 14)
    model.addConstr(7 * x0 + x1 + 5 * x2 >= 14)
    model.addConstr(-x0 + 5 * x1 >= 0)
    model.addConstr(8 * x0 + 9 * x2 <= 30)
    model.addConstr(2 * x1 + 9 * x2 <= 47)
    model.addConstr(8 * x0 + 2 * x1 <= 43)
    model.addConstr(8 * x0 + 2 * x1 + 9 * x2 <= 29)
    model.addConstr(7 * x0 + x1 <= 27)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Objective: {model.objVal}")
        print(f"Grams of fiber: {x0.varValue}")
        print(f"Milligrams of vitamin B5: {x1.varValue}")
        print(f"Milligrams of vitamin E: {x2.varValue}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
