
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin B2
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # grams of fat


    # Set objective function
    m.setObjective(3*x0 + 2*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(13*x0 + 13*x1 >= 52, "c0") # kidney support index
    m.addConstr(8*x0 + 3*x1 >= 32, "c1") # cardiovascular support index
    m.addConstr(-3*x0 + 7*x1 >= 0, "c2")
    m.addConstr(13*x0 + 13*x1 <= 125, "c3") # kidney support index upper bound
    m.addConstr(8*x0 + 3*x1 <= 55, "c4") # cardiovascular support index upper bound


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

