
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B2")
x2 = m.addVar(lb=0, name="grams_of_fat")

# Set the objective function
m.setObjective(3*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(13*x1 + 13*x2 >= 52, "kidney_support_index_min")
m.addConstr(8*x1 + 3*x2 >= 32, "cardiovascular_support_index_min")
m.addConstr(-3*x1 + 7*x2 >= 0, "additional_constraint")
m.addConstr(13*x1 + 13*x2 <= 125, "kidney_support_index_max")
m.addConstr(8*x1 + 3*x2 <= 55, "cardiovascular_support_index_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B2: {x1.x}")
    print(f"Grams of Fat: {x2.x}")
else:
    print("No optimal solution found")
