
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_vitamin_B2", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="grams_of_fat", lb=0)  # No lower bound specified, assuming 0

    # Define the objective function
    model.setObjective(3*x1 + 2*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(13*x1 + 13*x2 >= 52, name="kidney_support_index_min")
    model.addConstr(8*x1 + 3*x2 >= 32, name="cardiovascular_support_index_min")
    model.addConstr(-3*x1 + 7*x2 >= 0, name="linear_constraint")
    model.addConstr(13*x1 + 13*x2 <= 125, name="kidney_support_index_max")
    model.addConstr(8*x1 + 3*x2 <= 55, name="cardiovascular_support_index_max")

    # Optimize the model
    model.optimize()

    # Print the status of the model
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B2: {x1.varValue}")
        print(f"Grams of fat: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
