
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="blueberry_pies")
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="steaks")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_drumsticks")
x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="oreos")


# Set objective function
m.setObjective(2.01*x0**2 + 5.65*x0*x1 + 1.91*x0*x3 + 7.05*x1**2 + 6.82*x1*x2 + 2.36*x1*x3 + 7.51*x2**2 + 4.68*x3**2 + 7.09*x0 + 3.26*x1 + 1.66*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 2*x3 >= 35)
m.addConstr(14*x0 + 9*x2 >= 45)
m.addConstr(14*x0**2 + 2*x3**2 >= 31)
m.addConstr(2*x1 + 9*x2 + 2*x3 >= 46)
m.addConstr(14*x0**2 + 9*x2**2 + 2*x3**2 >= 46)
m.addConstr(2*x1 + 9*x2 + 2*x3 >= 37)
m.addConstr(14*x0**2 + 9*x2**2 + 2*x3**2 >= 37)
m.addConstr(14*x1 + x3 >= 20)
m.addConstr(20*x0 + 14*x2 >= 28)
m.addConstr(20*x0**2 + 14*x1**2 >= 17)
m.addConstr(14*x1 + 14*x2 >= 38)
m.addConstr(2*x1 + 2*x3 <= 93)
m.addConstr(14*x0 + 2*x1 <= 209)
m.addConstr(14*x0 + 2*x1 + 9*x2 + 2*x3 <= 209)
m.addConstr(20*x0**2 + 14*x2**2 <= 91)
m.addConstr(14*x2**2 + x3**2 <= 60)
m.addConstr(14*x1 + 14*x2 <= 135)
m.addConstr(20*x0**2 + 14*x1**2 <= 83)
m.addConstr(14*x1**2 + 14*x2**2 + x3**2 <= 122)
m.addConstr(20*x0 + 14*x1 + 14*x2 + x3 <= 122)
m.addConstr(14*x0 + 2*x1 + 9*x2 + 2*x3 <= 229)
m.addConstr(20*x0 + 14*x1 + 14*x2 + x3 <= 163)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

